﻿using System;
using System.Text;
using System.Data;
using System.Data.Common;
using System.Collections;
using System.Collections.Generic;
using System.Collections.Specialized;
using Winson.Framework.DBProviders;
using Winson.Framework.LogProviders;
using Winson.EntityOP.Base;
using Winson.EntityOP.Entity;

namespace Winson.EntityOP.BaseEntityOP
{	
	/// <summary>
    /// Order Details实体操作类
    /// </summary>
	public class OrderDetailsOP : BaseOP
    {
        #region 私有变量
        EntityCollection<OrderDetailsDS> OrderDetailsList;
        OrderDetailsDS orderdetailsDS;
        ArrayList fieldName;
        ArrayList fieldValue;
        List<ArrayList> fieldNameList;
        List<ArrayList> fieldValueList;
        #endregion

        #region 构造函数
        public OrderDetailsOP()
        {
            _tableName = "OrderDetails";
            sql = "select * from " + _tableName;
            _primekey = GetPrimeKey();
        }
        #endregion

        #region 查询操作
        /// <summary>
        /// 获取实体集合
        /// </summary>
        /// <param name="conditionValue">条件参数，如键名为"sql"，则为自定义条件;如为NULL则获取所有实体</param>
        /// <returns>实体集合</returns>
        public IList GetList(NameValueCollection conditionValue)
        {
            try
            {
                OrderDetailsList = new EntityCollection<OrderDetailsDS>();
                //将数据填充到实体集合
                DbDataReader dr = null;
                dr = DBManage.ExecuteReader(DBManage.Conn, sql, conditionValue);
                while (dr.Read())
                {
                    orderdetailsDS = new OrderDetailsDS();
                    FillDS(orderdetailsDS, dr);
                    OrderDetailsList.Add(orderdetailsDS);
                }
                return OrderDetailsList;
            }
            catch (Exception e)
            {
                LogManage.OutputErrLog(e, new Object[] { conditionValue });
                return null;
            }
            finally
            {
                DBManage.Conn.Close();
            }
        }
        /// <summary>
        /// 从数据库中获取单个实体
        /// </summary>
        /// <param name="conditionValue">条件参数，如键名为"sql"，则为自定义条件;如为NULL则获取最后一个新增的实体</param>
        /// <returns>实体</returns>
        public OrderDetailsDS GetEntity(NameValueCollection conditionValue)
        {
            DbDataReader dr = null;
            try
            {   
				 string tSql = string.Empty;
                if (conditionValue == null)
                {
                    tSql = "select top 1 * from " + _tableName + "order by " + _primekey + " desc";
                    dr = DBManage.ExecuteReader(DBManage.Conn, tSql, conditionValue);
                }
                else
                    dr = DBManage.ExecuteReader(DBManage.Conn, sql, conditionValue);
                
                if (dr.Read())
                {
                    orderdetailsDS = new OrderDetailsDS();
                    FillDS(orderdetailsDS, dr);
                    return orderdetailsDS;
                }
                else
                    return null;
            }
            catch (Exception e)
            {
                LogManage.OutputErrLog(e, new Object[] { conditionValue });
                return null;
            }
            finally
            {
                dr.Close();
                DBManage.Conn.Close();
            }
        }
        /// <summary>
        /// 从实体集合中获取单个实体
        /// </summary>
        /// <param name="entityList">实体集合</param>
        /// <param name="fieldID">实体ID</param>
        /// <returns>实体</returns>
        public OrderDetailsDS GetEntity(IList entityList, int fieldID)
        {
            try
            {
                foreach (OrderDetailsDS orderdetails_DS in entityList)
                {
                    if (orderdetails_DS.Orderid == fieldID)
                        return orderdetails_DS;
                }
                return null;
            }
            catch (Exception e)
            {
                LogManage.OutputErrLog(e, new Object[] { entityList, fieldID });
                return null;
            }
        }
        #endregion

        #region 单实体操作
        /// <summary>
        /// 添加实体
        /// </summary>
        /// <param name="ds">实体</param>
        /// <returns>影响记录数</returns>
        public int Add(OrderDetailsDS ds)
        {
            try
            {
                fieldName = new ArrayList();
                fieldValue = new ArrayList();
                int maxID = GetMaxID();
                for (int i = 0; i < ds.Count; i++)
                {
                    if (ds[i, 1, maxID] != null)
                    {
                        fieldName.Add(ds[i, 1, maxID]);
                        fieldValue.Add(ds[i, 0, maxID]);
                    }
                }
                return DBManage.ExecuteNonQuery(DBAction.Insert, _tableName, fieldName, fieldValue);
            }
            catch (Exception e)
            {
                LogManage.OutputErrLog(e, new Object[] { ds });
                return 0;
            }
        }
        /// <summary>
        /// 更新实体
        /// </summary>
        /// <param name="ds">实体</param>
        /// <param name="conditionValue">条件参数，如键名为"sql"，则为自定义条件</param>
        /// <returns>影响记录数</returns>
        public int Update(OrderDetailsDS ds, NameValueCollection conditionValue)
        {
            try
            {
                fieldName = new ArrayList();
                fieldValue = new ArrayList();
                for (int i = 0; i < ds.Count; i++)
                {
                    if (ds[i, 1, 0] != null)
                    {
                        fieldName.Add(ds[i, 1, 0]);
                        fieldValue.Add(ds[i, 0, 0]);
                    }
                }
                return DBManage.ExecuteNonQuery(DBAction.Update, _tableName, fieldName, fieldValue, conditionValue);
            }
            catch (Exception e)
            {
                LogManage.OutputErrLog(e, new Object[] { ds, conditionValue });
                return 0;
            }
        }
        /// <summary>
        /// 删除实体
        /// </summary>
        /// <param name="conditionValue">条件参数，如键名为"sql"，则为自定义条件</param>
        /// <returns>影响记录数</returns>
        public int Delete(NameValueCollection conditionValue)
        {
            try
            {
                return DBManage.ExecuteNonQuery(DBAction.Delete, _tableName, null, null, conditionValue);
            }
            catch (Exception e)
            {
                LogManage.OutputErrLog(e, new Object[] { conditionValue });
                return 0;
            }
        }
        #endregion

        #region 批量操作

        /// <summary>
        /// 批量添加实体
        /// </summary>
        /// <param name="dsList">实体集合</param>
        /// <returns>成功返回True 否则返回False</returns>
        public bool AddBatch(EntityCollection<OrderDetailsDS> dsList)
        {
            try
            {                
                fieldNameList = new List<ArrayList>();
                fieldValueList = new List<ArrayList>();
                int maxID = GetMaxID();
                foreach (OrderDetailsDS ds in dsList)
                {
                    fieldName = new ArrayList();
                    fieldValue = new ArrayList();
                    for (int n = 0; n < ds.Count; n++)
                    {
                        if (ds[n, 1, maxID] != null)
                        {
                            fieldName.Add(ds[n, 1, maxID]);
                            fieldValue.Add(ds[n, 0, maxID]);
                        }
                    }
                    maxID++;
                    fieldNameList.Add(fieldName);
                    fieldValueList.Add(fieldValue);
                }
                return DBManage.ExecuteBatch(DBAction.Insert, _tableName, fieldNameList, fieldValueList);
            }
            catch (Exception e)
            {
                LogManage.OutputErrLog(e, new Object[] { dsList });
                return false;
            }
        }

        /// <summary>
        /// 批量更新实体
        /// </summary>
        /// <param name="dsList">实体集合</param>
        /// <returns>成功返回True 否则返回False</returns>
        public bool UpdateBatch(EntityCollection<OrderDetailsDS> dsList)
        {
            try
            {
                fieldNameList = new List<ArrayList>();
                fieldValueList = new List<ArrayList>();

                foreach (OrderDetailsDS ds in dsList)
                {
                    if (ds[0, 1, 0] != null)
                    {
                        fieldName = new ArrayList();
                        fieldValue = new ArrayList();
                        for (int n = 0; n < ds.Count; n++)
                        {
                            if (ds[n, 1, 0] != null)
                            {
                                fieldName.Add(ds[n, 1, 0]);
                                fieldValue.Add(ds[n, 0, 0]);
                            }
                        }
                        fieldNameList.Add(fieldName);
                        fieldValueList.Add(fieldValue);
                    }
                    else
                        throw new Exception("主键值未设置，不能进行批量更新操作！主键必须为第一个字段");
                }
                return DBManage.ExecuteBatch(DBAction.Update, _tableName, fieldNameList, fieldValueList);
            }
            catch (Exception e)
            {
                LogManage.OutputErrLog(e, new Object[] { dsList });
                return false;
            }
        }

        /// <summary>
        /// 批量删除实体
        /// </summary>
        /// <param name="dsList">实体集合</param>
        /// <returns>成功返回True 否则返回False</returns>
        public bool DeleteBatch(EntityCollection<OrderDetailsDS> dsList)
        {
            try
            {
                fieldNameList = new List<ArrayList>();
                fieldValueList = new List<ArrayList>();

                foreach (OrderDetailsDS ds in dsList)
                {
                    if (ds[0, 1, 0] != null)
                    {
                        fieldName = new ArrayList();
                        fieldValue = new ArrayList();
                        for (int n = 0; n < ds.Count; n++)
                        {
                            if (ds[n, 1, 0] != null)
                            {
                                fieldName.Add(ds[n, 1, 0]);
                                fieldValue.Add(ds[n, 0, 0]);
                            }
                        }
                        fieldNameList.Add(fieldName);
                        fieldValueList.Add(fieldValue);
                    }
                    else
                        throw new Exception("主键值未设置，不能进行批量删除操作！主键必须为第一个字段");
                }
                return DBManage.ExecuteBatch(DBAction.Delete, _tableName, fieldNameList, fieldValueList);
            }
            catch (Exception e)
            {
                LogManage.OutputErrLog(e, new Object[] { dsList });
                return false;
            }
        }
        #endregion
    }
}


